package org.msh.etbm.rest.mobile;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.msh.etbm.commons.apidoc.annotations.ApiDoc;
import org.msh.etbm.commons.apidoc.annotations.ApiDocMethod;
import org.msh.etbm.rest.authentication.Authenticated;
import org.msh.etbm.rest.authentication.AuthenticationForm;
import org.msh.etbm.services.auth.AuthenticationService;
import org.msh.etbm.services.mobile.MobileInitService;
import org.msh.etbm.services.mobile.MobileLoginResponse;
import org.msh.etbm.services.mobile.MobileLoginService;
import org.msh.etbm.services.mobile.init.AdministrationResponse;
import org.msh.etbm.services.mobile.init.CaseData1Response;
import org.msh.etbm.services.mobile.init.CaseData2Response;
import org.msh.etbm.services.mobile.model.AdminUnitData;
import org.msh.etbm.services.mobile.model.TbCaseData;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.login.UserSession;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * Created by rmemoria on 15/4/17.
 */
@Name("mobileInitRest")
@Scope(ScopeType.APPLICATION)
@Path("/mobile")
@ApiDoc(
        group = "mobile",
        summary = "Return initialization data used in the mobile app initialization")
@AutoCreate
public class MobileInitRest {

    @In
    AuthenticationService authenticationService;

    @In
    MobileInitService mobileInitService;

    @In
    MobileLoginService mobileLoginService;


    @Path("/login")
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    @ApiDocMethod(summary = "Authenticate the user and return user information used by mobile app",
            description = "This is the same authentication method exposed by the login API, but returns " +
                    "extra information useful for mobile apps")
    public MobileLoginResponse mobileLogin(AuthenticationForm form) {
        return mobileLoginService.login(form);
    }

    @Path("/init/1")
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    @ApiDocMethod(summary = "Return initialization data of the step #1",
            description = "This API is used basically by the mobile app in order to return the initialization " +
                    "data of the logged user")
    @Authenticated
    public List<AdminUnitData> executeStep1() {
        Tbunit unit = UserSession.getUserWorkspace().getTbunit();
        return mobileInitService.generateInitDataStep1(unit);
    }

    @Path("/init/2")
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    @ApiDocMethod(summary = "Return initialization data of the step #2",
            description = "This API is used basically by the mobile app in order to return the initialization " +
                    "data of the logged user")
    @Authenticated
    public AdministrationResponse executeStep2() {
        Tbunit unit = UserSession.getUserWorkspace().getTbunit();
        return mobileInitService.generateIniDataStep2(unit);
    }


    @Path("/init/3")
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    @ApiDocMethod(summary = "Return initialization data of the step #3",
            description = "This API is used basically by the mobile app in order to return the initialization " +
                    "data of the logged user")
    @Authenticated
    public List<TbCaseData> executeStep3() {
        Tbunit unit = UserSession.getUserWorkspace().getTbunit();
        return mobileInitService.generateIniDataStep3(unit);
    }


    @Path("/init/4")
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    @ApiDocMethod(summary = "Return initialization data of the step #4",
            description = "This API is used basically by the mobile app in order to return the initialization " +
                    "data of the logged user")
    @Authenticated
    public CaseData1Response executeStep4() {
        Tbunit unit = UserSession.getUserWorkspace().getTbunit();
        return mobileInitService.generateIniDataStep4(unit);
    }


    @Path("/init/5")
    @Consumes({MediaType.APPLICATION_JSON})
    @Produces({MediaType.APPLICATION_JSON})
    @POST
    @ApiDocMethod(summary = "Return initialization data of the step #5",
            description = "This API is used basically by the mobile app in order to return the initialization " +
                    "data of the logged user")
    @Authenticated
    public CaseData2Response executeStep5() {
        Tbunit unit = UserSession.getUserWorkspace().getTbunit();
        return mobileInitService.generateIniDataStep5(unit);
    }

}
